(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16965,        507]
NotebookOptionsPosition[     15218,        446]
NotebookOutlinePosition[     15612,        463]
CellTagsIndexPosition[     15569,        460]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 ".NET/Link Example: WindowSpy (Using the Win32 API)\n\n",
 StyleBox["This example demonstrates calling \"unmanaged\" Windows DLLs (that \
is, an old C-style DLLs, not .NET assemblies) from ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" using ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DefineDLLFunction", "Input",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[". The DLL used is one from the Win32 API, the set of functions \
that Windows programs written in C or C++ call directly. Although most of the \
capabilities programmers need for programming on Windows are available via \
classes in the .NET Framework, there are some things that can only be done by \
getting right down to the level of the raw Win32 API. If you need to do it, \
it's nice to know that it is very simple.\n\nAlthough it might seem \
farfetched, this example demonstrates that ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" can realistically be used as a systems programming language for \
Windows. In fact, using ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DefineDLLFunction", "Input",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" to import Windows API functions into ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", you could write an entire native Win32 application in ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["!\n\nThis example presents a function called ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["WindowSpy", "Input",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", which will remind users of the \"Find Window\" functionality in \
the Spy++ utility program that has long been bundled with Microsoft's Visual \
C++ compiler. The ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["WindowSpy",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" program lets you move the mouse around the screen as it prints \
out information on the windows that it enters. These windows can belong to \
any program.\n\n",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["To try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code and Explanation", "Section"],

Cell["Needs[\"NETLink`\"]", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False],

Cell[CellGroupData[{

Cell["Declaring the Windows API Functions", "Subsection"],

Cell[TextData[{
 "Here are the C-language prototypes for the functions we need, straight out \
of the Microsoft documentation. All these functions are found in ",
 StyleBox["user32.dll", "Output"],
 ":"
}], "Text"],

Cell["\<\
BOOL GetWindowRect( HWND hWnd, LPRECT lpRect );
int GetWindowText( HWND hWnd, LPTSTR lpString, int nMaxCount );
int GetClassName( HWND hWnd, LPTSTR lpClassName, int nMaxCount );
HWND WindowFromPoint( POINT point );
BOOL GetCursorPos( LPPOINT lpPoint );
SHORT GetKeyState( int nVirtKey );\
\>", "Program"],

Cell[TextData[{
 "Before we work through the explanations of what type names to use in ",
 StyleBox["DefineDLLFunction", "Input"],
 " to call these functions from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", note that the easiest thing to do is to search on the internet for sample \
code in VB. NET or C# that shows declarations for the external functions, and \
just copy the type names. In Visual Basic .NET, external functions are \
declared using ",
 StyleBox["Declare Function", "Output"],
 ", and in C# they use the ",
 StyleBox["extern", "Output"],
 " modifier along with the ",
 StyleBox["DLLImport", "Output"],
 " attribute. You can use those terms, along with the DLL function name, as \
keywords in your search."
}], "Text"],

Cell[TextData[{
 StyleBox["DefineDLLFunction", "Input"],
 " understands common Windows types like HWND, BOOL, DWORD, SHORT, etc., so \
we can use those names directly. The simplest function is ",
 StyleBox["GetKeyState", "Output"],
 ":"
}], "Text"],

Cell["\<\
GetKeyState = DefineDLLFunction[\"GetKeyState\", \"user32.dll\", \"SHORT\", {\
\"int\"}];\
\>", "Input",
 InitializationCell->True],

Cell[TextData[{
 "Of course, there are many other ways to specify the type names for all of \
these functions. Here are some examples for ",
 StyleBox["GetKeyState", "Output"],
 ":"
}], "Text"],

Cell["\<\
(* C- or C#-style type names. *)
   GetKeyState = DefineDLLFunction[\"GetKeyState\", \"user32.dll\", \
\"short\", {\"int\"}];
(* .NET Framework type names. *)
   GetKeyState = DefineDLLFunction[\"GetKeyState\", \"user32.dll\", \
\"Int16\", {\"Int32\"}];
(* Visual Basic type names. *)
   GetKeyState = DefineDLLFunction[\"GetKeyState\", \"user32.dll\", \
\"Short\", {\"ByVal key As Integer\"}];\
\>", "Input",
 Evaluatable->False],

Cell[TextData[{
 StyleBox["WindowFromPoint", "Output"],
 " takes a ",
 StyleBox["POINT", "Output"],
 " structure. How does this map to .NET? Luckily there is a .NET ",
 StyleBox["Point", "Output"],
 " struct that has the same memory layout as the Windows ",
 StyleBox["POINT", "Output"],
 " struct. This lets us use the .NET type directly. The return value is an ",
 StyleBox["HWND", "Output"],
 ", and ",
 StyleBox["DefineDLLFunction", "Input"],
 " understands this type name, so you can use it directly (it is mapped to ",
 StyleBox["IntPtr", "Output"],
 ", the .NET class for a generic pointer). Note that because the type \
System.Drawing.Point is from an assembly that is probably not yet loaded, you \
use the ",
 StyleBox["ReferencedAssemblies", "Input"],
 " option to specify what assembly the type is found in. Alternatively, you \
can just call ",
 StyleBox["LoadNETAssembly[\"System.Drawing\"]", "Input"],
 " in advance to load the needed assembly."
}], "Text"],

Cell["\<\
WindowFromPoint = DefineDLLFunction[\"WindowFromPoint\", \"user32.dll\", \
\"HWND\", {\"System.Drawing.Point\"}, ReferencedAssemblies->{\"System.Drawing\
\"}];\
\>", "Input",
 InitializationCell->True],

Cell[TextData[{
 "The previous line causes the System.Drawing assembly to be loaded, so we \
could leave out the ",
 StyleBox["ReferencedAssemblies", "Input"],
 " option in subsequent declarations that also use the System.Drawing \
assembly, although we leave it in for completeness."
}], "Text"],

Cell[TextData[{
 StyleBox["GetCursorPos", "Output"],
 " takes an ",
 StyleBox["LPPOINT", "Output"],
 ", which is a pointer to a ",
 StyleBox["POINT", "Output"],
 ", because it needs to fill in the coordinates. In .NET terms, this maps to \
a ",
 StyleBox["Point", "Output"],
 " passed by reference. In general, making a parameter ",
 StyleBox["out", "Output"],
 " or ",
 StyleBox["ref", "Output"],
 " (",
 StyleBox["ByRef", "Output"],
 " in VB notation) is equivalent to adding one level of indirection. This \
means that a pointer to a ",
 StyleBox["POINT", "Output"],
 " is a ",
 StyleBox["Point", "Output"],
 " passed by reference. A \"by reference\" type in the .NET framework is \
designated with an & at the end:"
}], "Text"],

Cell["\<\
GetCursorPos = DefineDLLFunction[\"GetCursorPos\", \"user32.dll\", \"BOOL\", \
{\"System.Drawing.Point&\"}, ReferencedAssemblies->{\"System.Drawing\"}];\
\>", "Input",
 InitializationCell->True],

Cell["Here are some alternative ways to write that declaration:", "Text"],

Cell["\<\
(* C# syntax *)
GetCursorPos = DefineDLLFunction[\"GetCursorPos\", \"user32.dll\", \"bool\", \
{\"ref System.Drawing.Point\"}, ReferencedAssemblies->{\"System.Drawing\"}];
(* VB syntax *)
GetCursorPos = DefineDLLFunction[\"GetCursorPos\", \"user32.dll\", \
\"Boolean\", {\"ByRef pt As System.Drawing.Point\"}, \
ReferencedAssemblies->{\"System.Drawing\"}];\
\>", "Input",
 Evaluatable->False],

Cell[TextData[{
 StyleBox["GetClassName", "Output"],
 " and ",
 StyleBox["GetWindowText", "Output"],
 " both take an ",
 StyleBox["LPTSTR", "Output"],
 ", which is basically a string. However, these functions treat this \
parameter not as an \"in\" value, but as an \"out\" value--they write into \
the string as a means of supplying the desired result. In the typical case \
where a DLL function takes a string as an \"in\" argument, you can use any of \
the type names ",
 StyleBox["char*", "Output"],
 ", ",
 StyleBox["string", "Output"],
 ", or ",
 StyleBox["ByValue s As String", "Output"],
 ", but these won't work to propagate a value back out of the call, as \
required here. Instead, you use the .NET class ",
 StyleBox["System.Text.StringBuilder", "Output"],
 ". This is a standard .NET trick that is documented anywhere you find \
examples of passing strings to DLL functions."
}], "Text"],

Cell["\<\
GetWindowText = DefineDLLFunction[\"GetWindowText\", \"user32.dll\", \"int\", \
{\"HWND\", \"System.Text.StringBuilder\", \"int\"}];
GetClassName = DefineDLLFunction[\"GetClassName\", \"user32.dll\", \"int\", {\
\"HWND\", \"System.Text.StringBuilder\", \"int\"}];\
\>", "Input",
 InitializationCell->True],

Cell[TextData[{
 "The last function we need is ",
 StyleBox["GetWindowRect", "Output"],
 ". Like ",
 StyleBox["GetCursorPos", "Output"],
 ", it takes a pointer to a struct (",
 StyleBox["LPRECT", "Output"],
 "). .NET has a ",
 StyleBox["Rectangle", "Output"],
 " struct that is the same number of bytes as the Windows ",
 StyleBox["RECT", "Output"],
 " struct, but unfortunately it doesn't have the same layout of fields. A ",
 StyleBox["RECT", "Output"],
 " is stored as 4 ints: (left, top, right, bottom), whereas a ",
 StyleBox["Rectangle", "Output"],
 " is stored as (left, top, width, height). Because the structures are the \
same size in memory we can use the .NET ",
 StyleBox["Rectangle", "Output"],
 " as the type, but we must to do a little translating of the fields when we \
actually need to use their values, as can be seen later on."
}], "Text"],

Cell["\<\
GetWindowRect = DefineDLLFunction[\"GetWindowRect\", \"user32.dll\", \
\"BOOL\", {\"HWND\", \"System.Drawing.Rectangle&\"}, \
ReferencedAssemblies->{\"System.Drawing\"}];\
\>", "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["The WindowSpy Function", "Subsection"],

Cell[TextData[{
 "Now we  are ready to write the main ",
 StyleBox["WindowSpy", "Input"],
 " function."
}], "Text"],

Cell["\<\
WindowSpy[] :=
\tNETBlock[
\t\tModule[{rect, pt, sb1, sb2, dummyForm, lastWnd, curWnd},
\t\t\t(* This is the Rectangle we need to pass in to GetWindowRect. It is \
passed by reference and its fields
\t\t\t   are filled in by the function call.
\t\t\t*)
\t\t\trect = NETNew[\"System.Drawing.Rectangle\",0,0,0,0];
\t\t\t(* This is the Point we need to pass in to GetCursorPos. It is passed \
by reference and its fields
\t\t\t   are filled in by the function call.
\t\t\t*)
\t\t\tpt = NETNew[\"System.Drawing.Point\"];
\t\t\t(* We need two StringBuilders to pass in to the two calls that return \
text in an out parameter.
\t\t\t   We create them to hold 100 chars and then pass 100 as the max string \
length to the functions.
\t\t\t*)
\t\t\tsb1 = NETNew[\"System.Text.StringBuilder\", 100];
\t\t\tsb2 = NETNew[\"System.Text.StringBuilder\", 100];
\t\t\t(* It seems that for proper detection of the mouse click that \
terminates the function, we need
\t\t\t   to have a form visible. Therefore we create one and position it \
offscreen.
\t\t\t*)
\t\t\tdummyForm = NETNew[\"System.Windows.Forms.Form\"];
\t\t\tdummyForm@Location = NETNew[\"System.Drawing.Point\", -1000, -1000];
\t\t\t(* Need to use FormStartPosition->Manual to force the form to respect \
the Location we just set. *)
\t\t\tShowNETWindow[dummyForm, FormStartPosition->Manual];
\t\t\t
\t\t\tWhile[True,
\t\t\t\t(* This means \"if left mouse button was clicked, break out of the \
loop.\" *)
\t\t\t\tIf[GetKeyState[1] < 0, Break[]];
\t\t\t\tGetCursorPos[pt];
\t\t\t\tcurWnd = WindowFromPoint[pt];
\t\t\t\t(* The HWND is returned by WindowFromPoint is an IntPtr, but for \
comparing one IntPtr
\t\t\t\t   to another it is easiest to simply convert them to ints.
\t\t\t\t*)
\t\t\t\tIf[curWnd@ToInt32[] =!= lastWnd@ToInt32[],
\t\t\t\t\tGetClassName[curWnd, sb1, 100];
\t\t\t\t\tGetWindowText[curWnd, sb2, 100];
\t\t\t\t\tGetWindowRect[curWnd, rect];
\t\t\t\t\tPrint[StringForm[\"HWND: `1`     ClassName: `2`       Text: `3`     \
  Top: `4`  Left: `5`  Width: `6`  Height: `7`\",
\t\t\t\t\t\t\t\tcurWnd@ToInt32[], sb1@ToString[], sb2@ToString[],
\t\t\t\t\t\t\t\trect@X, rect@Y, rect@Width - rect@X, rect@Height - rect@Y]];
\t\t\t\t\tlastWnd = curWnd
\t\t\t\t]
\t\t\t];
\t\t\tdummyForm@Dispose[]
\t\t]
\t]\
\>", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell["WindowSpy[]", "Input"],

Cell[TextData[{
 StyleBox["Without clicking the mouse",
  FontSlant->"Italic"],
 ", move the mouse around the screen to see information printed about each of \
the windows it enters. If you are not familiar with Windows programming, \
you'll be interested to see how literally everything on the screen, even \
scroll bars and menu bars, is a window. To exit the program, click the \
mouse."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1001, 664},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 3715, 105, 493, "Title"],
Cell[CellGroupData[{
Cell[4330, 132, 39, 0, 67, "Section"],
Cell[4372, 134, 116, 3, 30, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[4513, 141, 57, 0, 38, "Subsection"],
Cell[4573, 143, 214, 5, 33, "Text"],
Cell[4790, 150, 314, 7, 127, "Program"],
Cell[5107, 159, 747, 17, 72, "Text"],
Cell[5857, 178, 248, 6, 34, "Text"],
Cell[6108, 186, 141, 4, 30, "Input",
 InitializationCell->True],
Cell[6252, 192, 193, 5, 33, "Text"],
Cell[6448, 199, 440, 11, 120, "Input",
 Evaluatable->False],
Cell[6891, 212, 972, 22, 93, "Text"],
Cell[7866, 236, 211, 5, 48, "Input",
 InitializationCell->True],
Cell[8080, 243, 296, 6, 53, "Text"],
Cell[8379, 251, 731, 22, 71, "Text"],
Cell[9113, 275, 204, 4, 48, "Input",
 InitializationCell->True],
Cell[9320, 281, 73, 0, 33, "Text"],
Cell[9396, 283, 402, 9, 120, "Input",
 Evaluatable->False],
Cell[9801, 294, 900, 21, 90, "Text"],
Cell[10704, 317, 315, 6, 48, "Input",
 InitializationCell->True],
Cell[11022, 325, 860, 20, 90, "Text"],
Cell[11885, 347, 222, 5, 48, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[12144, 357, 44, 0, 38, "Subsection"],
Cell[12191, 359, 115, 4, 34, "Text"],
Cell[12309, 365, 2370, 59, 822, "Input",
 InitializationCell->True]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[14728, 430, 26, 0, 37, "Section"],
Cell[14757, 432, 28, 0, 24, "Input"],
Cell[14788, 434, 402, 8, 41, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

